function Figure3(data)
visAllIndividual(data.borders, data.orgdata);
end

function [labstr, drawPline, colour] = getLabel(con)
if(strcmp(con,'ND_Y'))
    labstr = 'Yielding';
    drawPline = true;
    colour = [0 0 1];
elseif(strcmp(con,'D_Y'))
    labstr = 'Yielding';
    drawPline = true;
    colour = [0 0 1];
elseif(strcmp(con,'D_NY'))
    labstr = 'Non-yielding';
    drawPline = false;
    colour = [1 0 0];
elseif(strcmp(con,'ND_NY'))
    labstr = 'Non-yielding';
    drawPline = false;
    colour = [1 0 0];
end
end

function labstr = visIndividual(border, data, con, mapping)
strMap = {'Baseline','Look to yield','Look away to yield'};
fld_con = fieldnames(data);
c = find(strcmp(fld_con,con));
fld_map = fieldnames(data.(fld_con{c}));
m = find(strcmp(fld_map,mapping));
fld_phase = fieldnames(data.(fld_con{c}).(fld_map{m}).pos);
[labstr, drawPline, colour] = getLabel(con);

hold on
for i=1:length(fld_phase) % loop over phases
    if(drawPline==true)
        rectangle('Position',border.(fld_con{c}).(fld_map{m}).rect(i,:),'FaceColor',[0.9-i/10 0.9-i/10 0.9-i/10 0.4],'EdgeColor',[0 0 0]);
        text(border.(fld_con{c}).(fld_map{m}).midx(i), 60,['(',num2str(i),')'],'HorizontalAlignment','center','VerticalAlignment', 'top','FontSize',15,'FontWeight','bold');
    end
    plotdata = data.(fld_con{c}).(fld_map{m}).pos.(fld_phase{i});
    for j=1:length(plotdata)
        a = plot(plotdata{j}(:,1),plotdata{j}(:,2),'Color', colour,'LineWidth',1);
        if(j>1 || i>1)
            set(get(get(a,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
        end
    end
end
yl = yline(0,'--'); set(get(get(yl,'Annotation'),'LegendInformation'),'IconDisplayStyle','off'); % horizontal line
grid on
title(strMap(m),'FontSize',15,'FontWeight','bold');
if m==3
    xlabel('Time (s)','FontSize',10,'FontWeight','bold');
end
ylabel({'Distance (m)'},'FontSize',4,'FontWeight','bold');
ylim([border.(fld_con{1}).(fld_map{1}).rect(1,2), border.(fld_con{1}).(fld_map{1}).rect(1,2)+border.(fld_con{1}).(fld_map{1}).rect(1,4)]);
xlim([0, border.(fld_con{1}).(fld_map{m}).rect(end,1)+border.(fld_con{1}).(fld_map{1}).rect(end,3)]);
xticks(0:11);
ax=gca; ax.FontSize = 15;
end

function visAllIndividual(borders, data)
fld_con = fieldnames(data);
for c=1 % Only create a figure for 'Without second vehicle'
    fld_map = fieldnames(data.(fld_con{c}));
    figure;
    for m=1:length(fld_map) % loop over the 3 conditions
        subplot(3,1,m)
        a = visIndividual(borders, data, (fld_con{c}), (fld_map{m}));   % yielding trials
        b = visIndividual(borders, data, (fld_con{c+1}), (fld_map{m})); % no yielding trials
        legend(a,b,'Location','southwest');
    end
end
end
